/** @file   menumain.h
 * @brief   Declaraction of MenuMain - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MENU_MAIN_H
#define H_WWW_MENU_MAIN_H

#include "menupage.h"
#include "Font.h"
#include "Gradient.h"
#include "sprite.h"
#include <vector>

namespace WeWantWar {


/** @class  MenuMain
 * @brief   The MAIN MENU is an instance of this class.
 * @author  Tomi Lamminsaari
 */
class MenuMain : public MenuPage
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  /** ID of the PLAY DEMO - alternative. */
  static const int PLAY_THE_GAME = 0;
  /** ID of the LOAD GAME - alternative */
  static const int GOTO_LOADGAME_MENU = 1;
  /** ID of HIGHSCORES - alternative */
  static const int GOTO_HIGHSCORES_MENU = 2;
  /** ID of the SETTINGS - alternative */
  static const int GOTO_SETTINGS_MENU = 3;
  /** ID of the EXIT - alternative */
  static const int EXIT_THE_GAME = 4;
  
  
  
  
  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs the mainmenu-object.
   */
  MenuMain();
  
  /** Destructor.
   */
  virtual ~MenuMain();
  


  ///
  /// Public methods
  /// ==============

  /** Implemented update-method. See MenuPage - class for more information.
   */
  virtual int update();
  
  /** Redraws the mainmenu.
   */
  virtual void redraw();
  
  

  ///
  /// Public GET-methods
  /// ==================
  
  /** Returns the ID of this page. See MenuPage - class for more information.
   * @return    MenuPage::MAINMENU
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::MAINMENU; }
  

private:

  ///
  /// Protected methods
  /// =================
  
  /** This menu uses some sprites to show the graphics of the menuitems. Here
   * are the indices to the sprite-vector.
   */
  enum {
    SP_STARTGAME,
    SP_LOADGAME,
    SP_HIGHSCORES,
    SP_SETTINGS,
    SP_EXIT,
    
    SP_STARTGAME_SEL,
    SP_LOADGAME_SEL,
    SP_HIGHSCORES_SEL,
    SP_SETTINGS_SEL,
    SP_EXIT_SEL,
    
    SP_GRENADE,
    SP_HARDDISK,
    SP_TROPHY,
    SP_MONKEYWRENCH,
    SP_EXITIMAGE
  };
  
  
  /** Updates the fadein phase
   * @return    MenuPage::NO_PAGE_CHANGE
   */
  int updateFadeInState();
  
  /** Updates the visible phase
   * @return    MenuPage::NO_PAGE_CHANGE
   */
  int updateVisibleState();
  
  /** Updates the fadeout phase
   * @return    MenuPage::PAGE_CHANGE
   */
  int updateFadeOutState();
  
  
  /** Creates the help notes
   */
  void createHelpNotes();
  
  /** Initializes the graphics.
   */
  void initGraphics();
  
  /** Removes the graphics
   */
  void cleanupGraphics();
  
  
  
  ///
  /// Members
  /// =======

  /** The graphic contents of this menu are in this datafile. */
  DATAFILE* m_pDat;
  
  /** Each menuitem is a sprite. Those sprites are stored in this vector. */
  std::vector<eng2d::Sprite*> m_sprites;
  
  
private:

  ///
  /// Private methods
  /// ===============

  MenuMain(const MenuMain& rO);
  MenuMain& operator = (const MenuMain& rO);
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: menumain.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:03+02  lamminsa
 * Initial revision
 *
 */
 
